import Image from 'next/image'

import { Container } from '@/components/Container'
import backgroundImage from '@/images/background-faqs.jpg'

const faqs = [
  [
    {
      question: 'What is CRM',
      answer:
        'CRM stands for Customer Relationship Management. It is a system used to manage customer interactions through data efficiently. The goal of CRM is to understand, engage, and retain customers by providing tailored experiences.',
    },
    {
      question: 'Why is CRM important for businesses?',
      answer: 'CRM helps businesses improve customer satisfaction, increase loyalty, streamline operations, and optimize lead generation. It also allows companies to personalize their interactions with customers, leading to higher engagement and revenue growth.',
    },
    {
      question: 'What is customer journey mapping in CRM?',
      answer:
        'Customer journey mapping involves creating a visual representation of the customer experience across all touchpoints—from initial contact to final resolution. It helps identify key opportunities for engagement and enhances personalization.',
    },
  ],
  [
    {
      question: 'What role does CRM play in improving business performance?',
      answer:
        'By enhancing customer experience, CRM drives loyalty and retention. It also enables businesses to identify opportunities for upselling, cross-selling, and identifying potential customers who may be interested in buying your products or services.',
    },

    {
      question:
        'How does CRM enhance data security?',
      answer:
        'CRM platforms typically employ robust measures like encryption (e.g., AES-256) and multi-factor authentication to protect customer information, often complying with regulations such as GDPR or PCI-DSS to ensure responsible data handling.',
    },
  ],
  [
    {
      question:
        'What are some best practices for using CRM effectively?',
      answer:
        'Regularly update customer data to ensure accuracy; schedule customer interactions based on business goals; use CRM to gather feedback for product improvement; and analyze metrics to identify areas for service quality enhancement.',
    },
    {
      question: 'What is customer journey mapping in CRM?',
      answer:
        'Customer journey mapping involves creating a visual representation of the customer experience across all touchpoints—from initial contact to final resolution. It helps identify key opportunities for engagement and enhances personalization.',
    },
  ],
]

export function Faqs() {
  return (
    <section
      id="faq"
      aria-labelledby="faq-title"
      className="relative overflow-hidden bg-slate-50 py-20 sm:py-32"
    >
      <Image
        className="absolute top-0 left-1/2 max-w-none -translate-y-1/4 translate-x-[-30%]"
        src={backgroundImage}
        alt=""
        width={1558}
        height={946}
        unoptimized
      />
      <Container className="relative">
        <div className="mx-auto max-w-2xl lg:mx-0">
          <h2
            id="faq-title"
            className="font-display text-3xl tracking-tight text-slate-900 sm:text-4xl"
          >
            Frequently asked questions
          </h2>
          <p className="mt-4 text-lg tracking-tight text-slate-700">
          Unlock Your Business Potential with Our Comprehensive CRM FAQ Guide
          </p>
        </div>
        <ul
          role="list"
          className="mx-auto mt-16 grid max-w-2xl grid-cols-1 gap-8 lg:max-w-none lg:grid-cols-3"
        >
          {faqs.map((column, columnIndex) => (
            <li key={columnIndex}>
              <ul role="list" className="flex flex-col gap-y-8">
                {column.map((faq, faqIndex) => (
                  <li key={faqIndex}>
                    <h3 className="font-display text-lg/7 text-slate-900">
                      {faq.question}
                    </h3>
                    <p className="mt-4 text-sm text-slate-700">{faq.answer}</p>
                  </li>
                ))}
              </ul>
            </li>
          ))}
        </ul>
      </Container>
    </section>
  )
}
